/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epta.datagen;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.CrusherRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.recipe.PulverizerRecipe;
import me.jddev0.ep.recipe.SawmillRecipe;
import me.jddev0.ep.registry.tags.CommonItemTags;
import me.jddev0.epta.item.EPTAItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;

public class ModRecipeProvider
extends FabricRecipeProvider {
    private static final String THE_AETHER_MOD_ID = "aether";
    private static final String PATH_PREFIX = "compat/aether/";

    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> lookupProvider) {
        super(output, lookupProvider);
    }

    public void method_10419(class_8790 output) {
        this.buildCraftingRecipes(output);
        this.buildCrusherRecipes(output);
        this.buildPulverizerRecipes(output);
        this.buildSawmillRecipes(output);
        this.buildPlantGrowthChamberRecipes(output);
    }

    private void buildCraftingRecipes(class_8790 output) {
        this.buildToolsCraftingRecipes(output);
        this.buildItemTransportCraftingRecipes(output);
    }

    private void buildToolsCraftingRecipes(class_8790 output) {
        ModRecipeProvider.addHammerCraftingRecipe(output, (class_6862<class_1792>)AetherTags.Items.SKYROOT_TOOL_CRAFTING, (class_1935)EPTAItems.SKYROOT_HAMMER);
        ModRecipeProvider.addHammerCraftingRecipe(output, (class_1935)AetherBlocks.HOLYSTONE.get(), (class_1935)EPTAItems.HOLYSTONE_HAMMER);
        ModRecipeProvider.addHammerCraftingRecipe(output, (class_6862<class_1792>)AetherTags.Items.GEMS_ZANITE, (class_1935)EPTAItems.ZANITE_HAMMER);
        ModRecipeProvider.addHammerCraftingRecipe(output, (class_6862<class_1792>)AetherTags.Items.PROCESSED_GRAVITITE, (class_1935)EPTAItems.GRAVITITE_HAMMER);
    }

    private void buildItemTransportCraftingRecipes(class_8790 output) {
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_ITEM), Map.of(Character.valueOf('C'), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE.get()}), Character.valueOf('c'), class_1856.method_8091((class_1935[])new class_1935[]{EPBlocks.ITEM_CONVEYOR_BELT_ITEM}), Character.valueOf('H'), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8239})), new String[]{"CCC", "CHC", "CcC"}, new class_1799((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM), class_7710.field_40251);
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM), Map.of(Character.valueOf('C'), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE.get()}), Character.valueOf('I'), class_1856.method_8106((class_6862)ConventionalItemTags.STORAGE_BLOCKS_IRON), Character.valueOf('R'), class_1856.method_8106((class_6862)ConventionalItemTags.STORAGE_BLOCKS_REDSTONE), Character.valueOf('L'), class_1856.method_8091((class_1935[])new class_1935[]{EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM})), new String[]{"CRC", "ILI", "CRC"}, new class_1799((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_SORTER_ITEM), class_7710.field_40251);
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM), Map.of(Character.valueOf('C'), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE.get()}), Character.valueOf('I'), class_1856.method_8106((class_6862)CommonItemTags.PLATES_IRON), Character.valueOf('R'), class_1856.method_8106((class_6862)ConventionalItemTags.REDSTONE_DUSTS), Character.valueOf('l'), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8865}), Character.valueOf('L'), class_1856.method_8091((class_1935[])new class_1935[]{EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM})), new String[]{"ClC", "ILI", "CRC"}, new class_1799((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_SWITCH_ITEM), class_7710.field_40251);
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM), Map.of(Character.valueOf('C'), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE.get()}), Character.valueOf('I'), class_1856.method_8106((class_6862)CommonItemTags.PLATES_IRON), Character.valueOf('R'), class_1856.method_8106((class_6862)ConventionalItemTags.REDSTONE_DUSTS), Character.valueOf('L'), class_1856.method_8091((class_1935[])new class_1935[]{EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM})), new String[]{"CIC", "ILI", "CRC"}, new class_1799((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_SPLITTER_ITEM), class_7710.field_40251);
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM), Map.of(Character.valueOf('C'), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE.get()}), Character.valueOf('I'), class_1856.method_8106((class_6862)CommonItemTags.PLATES_IRON), Character.valueOf('R'), class_1856.method_8106((class_6862)ConventionalItemTags.REDSTONE_DUSTS), Character.valueOf('L'), class_1856.method_8091((class_1935[])new class_1935[]{EPBlocks.ITEM_CONVEYOR_BELT_LOADER_ITEM})), new String[]{"CRC", "ILI", "CIC"}, new class_1799((class_1935)EPBlocks.ITEM_CONVEYOR_BELT_MERGER_ITEM), class_7710.field_40251);
    }

    private void buildCrusherRecipes(class_8790 output) {
        this.addCrusherRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.HOLYSTONE_BRICKS.get()}), new class_1799((class_1935)AetherBlocks.HOLYSTONE.get()), "holystone_bricks");
    }

    private void buildPulverizerRecipes(class_8790 output) {
        ModRecipeProvider.addPulverizerRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.AMBROSIUM_ORE.get()}), new PulverizerRecipe.OutputItemStackWithPercentages(new class_1799((class_1935)AetherItems.AMBROSIUM_SHARD.get()), new double[]{1.0, 0.67, 0.17}, new double[]{1.0, 0.67, 0.33, 0.17}), "ambrosium_ores");
        ModRecipeProvider.addPulverizerRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.ZANITE_ORE.get()}), new PulverizerRecipe.OutputItemStackWithPercentages(new class_1799((class_1935)AetherItems.ZANITE_GEMSTONE.get()), new double[]{1.0, 0.67, 0.17}, new double[]{1.0, 0.67, 0.33, 0.17}), "zanite_ores");
    }

    private void buildSawmillRecipes(class_8790 output) {
        this.addBasicWoodSawmillRecipe(output, new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get()), class_1856.method_8106((class_6862)AetherTags.Items.CRAFTS_SKYROOT_PLANKS), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_FENCE.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_FENCE_GATE.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_DOOR.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_TRAPDOOR.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_PRESSURE_PLATE.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_SIGN.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_BOAT.get()}), class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_CHEST_BOAT.get()}), false, "skyroot");
        ModRecipeProvider.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_BOOKSHELF.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 6), new class_1799((class_1935)class_1802.field_8529, 3), "skyroot_planks", "skyroot_bookshelf");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_BUCKET.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 2), 3, "skyroot_planks", "skyroot_bucket");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_SWORD.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 2), 1, "skyroot_planks", "skyroot_sword");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_SHOVEL.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get()), 2, "skyroot_planks", "skyroot_shovel");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_PICKAXE.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 3), 2, "skyroot_planks", "skyroot_pickaxe");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_AXE.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 3), 2, "skyroot_planks", "skyroot_axe");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherItems.SKYROOT_HOE.get()}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 2), 2, "skyroot_planks", "skyroot_hoe");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{EPTAItems.SKYROOT_HAMMER}), new class_1799((class_1935)AetherBlocks.SKYROOT_PLANKS.get(), 2), 2, "skyroot_planks", "skyroot_hammer");
        this.addSawmillRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.SKYROOT_PLANKS.get()}), new class_1799((class_1935)AetherItems.SKYROOT_STICK.get(), 3), 1, "skyroot_sticks", "skyroot_planks");
    }

    private void buildPlantGrowthChamberRecipes(class_8790 output) {
        this.addBasicFlowerGrowingRecipe(output, (class_1935)AetherBlocks.PURPLE_FLOWER.get(), "purple_flower");
        this.addBasicFlowerGrowingRecipe(output, (class_1935)AetherBlocks.WHITE_FLOWER.get(), "white_flower");
        this.addPlantGrowthChamberRecipe(output, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)AetherBlocks.BERRY_BUSH_STEM.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new class_1799((class_1935)AetherBlocks.BERRY_BUSH_STEM.get()), new double[]{1.0}), new OutputItemStackWithPercentages(new class_1799((class_1935)AetherItems.BLUE_BERRY.get()), new double[]{1.0, 0.75, 0.25})}, 16000, "blue_berry", "berry_bush_stem");
    }

    private static void addHammerCraftingRecipe(class_8790 output, class_1935 materialInput, class_1935 hammerItem) {
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10426((class_1935)materialInput), Map.of(Character.valueOf('S'), class_1856.method_8106((class_6862)AetherTags.Items.SKYROOT_STICKS), Character.valueOf('M'), class_1856.method_8091((class_1935[])new class_1935[]{materialInput})), new String[]{" M ", " SM", "S  "}, new class_1799(hammerItem), class_7710.field_40251);
    }

    private static void addHammerCraftingRecipe(class_8790 output, class_6862<class_1792> materialInput, class_1935 hammerItem) {
        ModRecipeProvider.addShapedCraftingRecipe(output, (class_175<class_2066.class_2068>)ModRecipeProvider.method_10420(materialInput), Map.of(Character.valueOf('S'), class_1856.method_8106((class_6862)AetherTags.Items.SKYROOT_STICKS), Character.valueOf('M'), class_1856.method_8106(materialInput)), new String[]{" M ", " SM", "S  "}, new class_1799(hammerItem), class_7710.field_40251);
    }

    private static void addShapedCraftingRecipe(class_8790 output, class_175<class_2066.class_2068> hasIngredientTrigger, Map<Character, class_1856> key, String[] pattern, class_1799 result, class_7710 category) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, "");
    }

    private static void addShapedCraftingRecipe(class_8790 output, class_175<class_2066.class_2068> hasIngredientTrigger, Map<Character, class_1856> key, String[] pattern, class_1799 result, class_7710 category, String group) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, "");
    }

    private static void addShapedCraftingRecipe(class_8790 output, class_175<class_2066.class_2068> hasIngredientTrigger, Map<Character, class_1856> key, String[] pattern, class_1799 result, class_7710 category, String group, String recipeIdSuffix) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, recipeIdSuffix, "");
    }

    private static void addShapedCraftingRecipe(class_8790 output, class_175<class_2066.class_2068> hasIngredientTrigger, Map<Character, class_1856> key, String[] pattern, class_1799 result, class_7710 category, String group, String recipeIdSuffix, String recipeIdPrefix) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/crafting/" + recipeIdPrefix + ModRecipeProvider.method_33716((class_1935)result.method_7909()) + recipeIdSuffix));
        class_161.class_162 advancementBuilder = output.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_705("has_the_ingredient", hasIngredientTrigger).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        class_1869 recipe = new class_1869(Objects.requireNonNullElse(group, ""), category, class_8957.method_55086(key, (String[])pattern), result);
        output.method_53819(recipeId, (class_1860)recipe, advancementBuilder.method_695(recipeId.method_45138("recipes/")));
    }

    private void addCrusherRecipe(class_8790 RecipeExporter, class_1856 input, class_1799 output, String recipeIngredientName) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/crusher/" + ModRecipeProvider.method_33716((class_1935)output.method_7909()) + "_from_crushing_" + recipeIngredientName));
        CrusherRecipe recipe = new CrusherRecipe(output, input);
        RecipeExporter.method_53819(recipeId, (class_1860)recipe, null);
    }

    private static void addPulverizerRecipe(class_8790 RecipeExporter, class_1856 input, PulverizerRecipe.OutputItemStackWithPercentages output, String recipeIngredientName) {
        ModRecipeProvider.addPulverizerRecipe(RecipeExporter, input, output, new PulverizerRecipe.OutputItemStackWithPercentages(class_1799.field_8037, new double[0], new double[0]), recipeIngredientName);
    }

    private static void addPulverizerRecipe(class_8790 RecipeExporter, class_1856 input, PulverizerRecipe.OutputItemStackWithPercentages output, PulverizerRecipe.OutputItemStackWithPercentages secondaryOutput, String recipeIngredientName) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/pulverizer/" + ModRecipeProvider.method_33716((class_1935)output.output().method_7909()) + "_from_pulverizer_" + recipeIngredientName));
        PulverizerRecipe recipe = new PulverizerRecipe(output, secondaryOutput, input);
        RecipeExporter.method_53819(recipeId, (class_1860)recipe, null);
    }

    private void addBasicWoodSawmillRecipe(class_8790 RecipeExporter, class_1799 planksItem, class_1856 logsInput, class_1856 fenceInput, class_1856 fenceGateInput, class_1856 doorInput, class_1856 trapdoorInput, class_1856 pressurePlateInput, class_1856 signInput, class_1856 boatInput, class_1856 chestBoatInput, boolean isRaft, String woodName) {
        this.addSawmillRecipe(RecipeExporter, logsInput, planksItem.method_46651(6), 1, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_logs");
        this.addBasicWoodWithoutLogsSawmillRecipe(RecipeExporter, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, boatInput, chestBoatInput, isRaft, woodName);
    }

    private void addBasicWoodWithoutLogsSawmillRecipe(class_8790 RecipeExporter, class_1799 planksItem, class_1856 fenceInput, class_1856 fenceGateInput, class_1856 doorInput, class_1856 trapdoorInput, class_1856 pressurePlateInput, class_1856 signInput, class_1856 boatInput, class_1856 chestBoatInput, boolean isRaft, String woodName) {
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(RecipeExporter, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, woodName);
        this.addSawmillRecipe(RecipeExporter, boatInput, planksItem.method_46651(4), 3, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + (isRaft ? "_raft" : "_boat"));
        this.addSawmillRecipe(RecipeExporter, chestBoatInput, planksItem.method_46651(5), 7, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + (isRaft ? "_chest_raft" : "_chest_boat"));
    }

    private void addBasicWoodWithoutLogsAndBoatsSawmillRecipe(class_8790 RecipeExporter, class_1799 planksItem, class_1856 fenceInput, class_1856 fenceGateInput, class_1856 doorInput, class_1856 trapdoorInput, class_1856 pressurePlateInput, class_1856 signInput, String woodName) {
        this.addSawmillRecipe(RecipeExporter, fenceInput, planksItem, 2, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_fence");
        this.addSawmillRecipe(RecipeExporter, fenceGateInput, planksItem.method_46651(2), 3, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_fence_gate");
        this.addSawmillRecipe(RecipeExporter, doorInput, planksItem, 3, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_door");
        this.addSawmillRecipe(RecipeExporter, trapdoorInput, planksItem.method_46651(2), 3, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_trapdoor");
        this.addSawmillRecipe(RecipeExporter, pressurePlateInput, planksItem, 2, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_pressure_plate");
        this.addSawmillRecipe(RecipeExporter, signInput, planksItem.method_46651(2), 1, ModRecipeProvider.method_33716((class_1935)planksItem.method_7909()), woodName + "_sign");
    }

    private void addSawmillRecipe(class_8790 RecipeExporter, class_1856 input, class_1799 output, int sawdustAmount, String outputName, String recipeIngredientName) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName));
        SawmillRecipe recipe = new SawmillRecipe(output, input, sawdustAmount);
        RecipeExporter.method_53819(recipeId, (class_1860)recipe, null);
    }

    private static void addSawmillRecipe(class_8790 RecipeExporter, class_1856 input, class_1799 output, class_1799 secondaryOutput, String outputName, String recipeIngredientName) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName));
        SawmillRecipe recipe = new SawmillRecipe(output, secondaryOutput, input);
        RecipeExporter.method_53819(recipeId, (class_1860)recipe, null);
    }

    private void addBasicFlowerGrowingRecipe(class_8790 RecipeExporter, class_1935 flowerItem, String outputName) {
        this.addPlantGrowthChamberRecipe(RecipeExporter, class_1856.method_8091((class_1935[])new class_1935[]{flowerItem}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new class_1799(flowerItem), new double[]{1.0, 1.0, 0.33})}, 16000, outputName, ModRecipeProvider.method_33716((class_1935)flowerItem));
    }

    private void addPlantGrowthChamberRecipe(class_8790 RecipeExporter, class_1856 input, OutputItemStackWithPercentages[] outputs, int ticks, String outputName, String recipeIngredientName) {
        class_2960 recipeId = class_2960.method_60655((String)"energizedpowerta", (String)("compat/aether/growing/" + outputName + "_from_growing_" + recipeIngredientName));
        PlantGrowthChamberRecipe recipe = new PlantGrowthChamberRecipe(outputs, input, ticks);
        RecipeExporter.method_53819(recipeId, (class_1860)recipe, null);
    }
}

